/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view.monitors;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.LasersResources;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.model.mirror.PartialMirror;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PowerMeterGraphic
extends GraphicLayerSet {
    public PowerMeterGraphic(Component component, LaserModel laserModel, final PartialMirror partialMirror) throws HeadlessException {
        super(component);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, LasersResources.getImage("power-meter.png"));
        this.addGraphic(phetImageGraphic);
        int n = 70;
        int n2 = 30;
        int n3 = 25;
        Dimension dimension = new Dimension(200, 30);
        final InsideMeter insideMeter = new InsideMeter(component, dimension, Meter.HORIZONTAL);
        insideMeter.setLocation(n, n2);
        this.addGraphic(insideMeter);
        final OutsideMeter outsideMeter = new OutsideMeter(component, dimension, Meter.HORIZONTAL);
        outsideMeter.setLocation(n, (int)(insideMeter.getLocation().getY() + dimension.getHeight() + (double)n3));
        this.addGraphic(outsideMeter);
        laserModel.addLaserListener(new LaserModel.ChangeListenerAdapter(){

            public void lasingPopulationChanged(LaserModel.ChangeEvent changeEvent) {
                super.lasingPopulationChanged(changeEvent);
                insideMeter.update(changeEvent.getLasingPopulation());
                outsideMeter.update((double)changeEvent.getLasingPopulation() * (1.0 - partialMirror.getReflectivity()));
            }
        });
        this.setBoundsDirty();
        this.repaint();
    }

    private static class InsideMeter
    extends Meter {
        public InsideMeter(Component component, Dimension dimension, Object object) {
            super(component, dimension, object);
            Object object2;
            int n;
            for (n = 0; n < this.segments.length; ++n) {
                double d = (double)(n * (this.segmentWidth + this.interSegmentSpace)) * this.scale;
                object2 = null;
                object2 = d < (double)LasersConfig.LASING_THRESHOLD ? this.belowLasingPaint : (d >= (double)LasersConfig.LASING_THRESHOLD && d < this.dangerThreshold ? this.lasingPaint : (d >= this.dangerThreshold ? this.aboveLasingPaint : this.backgroundColor));
                this.segments[n].setPaint((Paint)object2);
            }
            n = (int)((double)LasersConfig.LASING_THRESHOLD / this.scale);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, this.background.getHeight(), 2.0, 15.0);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component, double_, new Color(255, 255, 255));
            phetShapeGraphic.setLocation(n, 0);
            this.addGraphic(phetShapeGraphic);
            object2 = new PhetShapeGraphic(component, double_, new Color(255, 255, 255));
            int n2 = (int)(this.dangerThreshold / this.scale);
            ((PhetGraphic)object2).setLocation(n2, 0);
            this.addGraphic((PhetGraphic)object2);
            String string = LasersResources.getString("PowerMeter.Lasing");
            PhetFont phetFont = new PhetFont(1, 12);
            PhetTextGraphic phetTextGraphic = new PhetTextGraphic();
            phetTextGraphic.setComponent(component);
            phetTextGraphic.setFont(phetFont);
            phetTextGraphic.setJustification(6);
            phetTextGraphic.setText(string);
            phetTextGraphic.setColor(Color.green);
            phetTextGraphic.setLocation((n + n2) / 2, (int)this.background.getHeight() + 15);
            this.addGraphic(phetTextGraphic);
            String string2 = LasersResources.getString("PowerMeter.Danger");
            PhetTextGraphic phetTextGraphic2 = new PhetTextGraphic();
            phetTextGraphic2.setComponent(component);
            phetTextGraphic2.setFont(phetFont);
            phetTextGraphic2.setJustification(6);
            phetTextGraphic2.setText(string2);
            phetTextGraphic2.setColor(Color.red);
            phetTextGraphic2.setLocation((int)((double)n2 + this.background.getWidth()) / 2 + 10, (int)this.background.getHeight() + 15);
            this.addGraphic(phetTextGraphic2);
        }
    }

    private static abstract class Meter
    extends CompositePhetGraphic {
        static final Object HORIZONTAL = new Object();
        static final Object VERTICAL = new Object();
        Object orientation;
        private Insets insets;
        Rectangle2D background;
        Paint backgroundColor = Color.black;
        PhetShapeGraphic[] segments;
        Paint belowLasingPaint = Color.white;
        Paint lasingPaint = Color.green;
        Paint aboveLasingPaint = Color.red;
        int segmentWidth = 3;
        int interSegmentSpace = 1;
        double dangerThreshold = (double)LasersConfig.KABOOM_THRESHOLD * 0.75;
        double scale;

        public Meter(Component component, Dimension dimension, Object object) {
            super(component);
            boolean bl = false;
            if (object == VERTICAL) {
                bl = true;
                this.insets = new Insets(0, 5, 0, 5);
            }
            if (object == HORIZONTAL) {
                bl = true;
                this.insets = new Insets(5, 0, 5, 0);
            }
            if (!bl) {
                throw new IllegalArgumentException();
            }
            this.orientation = object;
            this.background = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component, this.background, this.backgroundColor);
            this.addGraphic(phetShapeGraphic);
            this.scale = (double)LasersConfig.KABOOM_THRESHOLD / this.background.getWidth();
            int n = (int)(this.background.getWidth() / (double)(this.segmentWidth + this.interSegmentSpace));
            this.segments = new PhetShapeGraphic[n];
            for (int i = 0; i < this.segments.length; ++i) {
                PhetShapeGraphic phetShapeGraphic2;
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(this.background.getX() + (double)(i * (this.segmentWidth + this.interSegmentSpace)), this.background.getY() + (double)this.insets.top, this.segmentWidth, this.background.getHeight() - (double)this.insets.top - (double)this.insets.bottom, 3.0, 3.0);
                this.segments[i] = phetShapeGraphic2 = new PhetShapeGraphic(component, double_, this.backgroundColor);
                this.addGraphic(phetShapeGraphic2);
            }
            this.update(0.0);
            this.setBoundsDirty();
            this.repaint();
        }

        public void update(double d) {
            for (int i = 0; i < this.segments.length; ++i) {
                PhetShapeGraphic phetShapeGraphic = this.segments[i];
                double d2 = (double)(i * (this.segmentWidth + this.interSegmentSpace)) * this.scale;
                boolean bl = d > d2;
                phetShapeGraphic.setVisible(bl);
            }
            this.setBoundsDirty();
            this.repaint();
        }
    }

    private static class OutsideMeter
    extends Meter {
        public OutsideMeter(Component component, Dimension dimension, Object object) {
            super(component, dimension, object);
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i].setPaint(Color.white);
            }
        }
    }
}

